#!/usr/bin/perl
use strict;
use warnings;
use Encode;
use Unicode::Normalize qw(normalize);
use XML::Simple;
use Data::Dumper;
use MIME::Base64;

use LWP::Simple qw(get);

binmode STDOUT, ":utf8";

my @timeData = localtime(time);
my $year = 1900 + $timeData[5];
my $month = $timeData[4] + 1;
my $day = $timeData[3];
printf ("$year-%02d-%02d\n",$month,$day);

sub processDLC($)
{
	my $mediaId = shift;
	my $page_num = 1;
	my $count = 0;
	my $items = 0;
	do
	{
		my $page = get "http://catalog.xboxlive.com/Catalog/Catalog.asmx/Query?methodName=FindGameOffers&Names=Locale&Values=en-US&Names=LegalLocale&Values=en-US&Names=Store&Values=1&Names=PageSize&Values=100&Names=PageNum&Values=$page_num&Names=AvatarBodyTypes&Values=3&Names=AvatarBodyTypes&Values=1&Names=DetailView&Values=5&Names=Relations&Values=2&Names=UserTypes&Values=2&Names=MediaIds&Values=$mediaId&Names=MediaTypes&Values=18&Names=ImageFormats&Values=4&Names=ImageFormats&Values=5&Names=ImageSizes&Values=15&Names=OrderBy&Values=5&Names=OrderDirection&Values=2";
		my $xml = new XML::Simple(searchpath => ".",
			forcearray => 2);
		my $data = $xml->XMLin($page);
		$items = $data->{'live:totalItems'}->[0];
	
		foreach my $entry (@{$data->{entry}}) {
			$count = $count + 1;
			my $Ctitle = $entry->{'live:offer'}->[0]->{'live:gameReducedTitle'}->[0];
			my $title = $entry->{'title'}->[0];
			my $newDate = $entry->{'live:offer'}->[0]->{'live:offerInstances'}->[0]->{'live:offerInstance'}->[0]->{'live:startDateTime'}->[0];
			$newDate = substr($newDate,0,10);
			$newDate =~ s/-/\//g;
			my $rating = $entry->{'live:offer'}->[0]->{'live:ratingId'}->[0];
			my $rating_perc = $entry->{'live:offer'}->[0]->{'live:ratingAggregate'}->[0];
			my $raters = $entry->{'live:offer'}->[0]->{'live:numberOfRatings'}->[0];
			my $titleId = $entry->{'live:offer'}->[0]->{'live:titleId'}->[0];
			my $encoded64 = $entry->{'live:mediaInstances'}->[0]->{'live:gameMediaInstance'}->[0]->{'live:contentId'}->[0];
			my $decoded = decode_base64($encoded64);
			
			my $fileName;
			foreach $b (split //, $decoded) {
			    $fileName .= sprintf("%02X",ord($b));
			}
			$titleId = sprintf("%08X",int($titleId));
			$fileName .= substr($titleId,0,2);
			print "[$Ctitle],$newDate,$rating,$rating_perc,$raters,$title,$fileName\n";
		}
		$page_num++;
	}while($count < $items)
}




my $page_num = 1;
my $count = 0;

my $items = 0;

do
{
	my $page = get "http://catalog.xboxlive.com/Catalog/Catalog.asmx/Query?methodName=FindGames&Names=Locale&Values=en-US&Names=LegalLocale&Values=en-US&Names=Store&Values=1&Names=PageSize&Values=100&Names=PageNum&Values=$page_num&Names=AvatarBodyTypes&Values=3&Names=AvatarBodyTypes&Values=1&Names=DetailView&Values=1&Names=OfferFilterLevel&Values=2&Names=UserTypes&Values=2&Names=MediaTypes&Values=1&Names=MediaTypes&Values=21&Names=MediaTypes&Values=23&Names=CategoryIds&Values=3027&Names=OfferTargetMediaTypes&Values=18&Names=ImageFormats&Values=4&Names=ImageFormats&Values=5&Names=ImageSizes&Values=15&Names=ImageSizes&Values=23&Names=OrderBy&Values=1&Names=OrderDirection&Values=1";
	my $xml = new XML::Simple(searchpath => ".",
		forcearray => 2);
	my $data = $xml->XMLin($page);
	
	$items = $data->{'live:totalItems'}->[0];
	
	foreach my $entry (@{$data->{entry}}) {
		$count = $count + 1;
		my $urnuuid = substr($entry->{'id'}->[0],9);
		processDLC($urnuuid);
	}
	$page_num++;
}while($count < $items);


    


